
#ifdef HAVE_CONFIG_H
#include "../../../ext_config.h"
#endif

#include <php.h>
#include "../../../php_ext.h"
#include "../../../ext.h"

#include <Zend/zend_operators.h>
#include <Zend/zend_exceptions.h>
#include <Zend/zend_interfaces.h>

#include "kernel/main.h"
#include "kernel/object.h"
#include "kernel/memory.h"


/**
 * This file is part of the Phalcon Framework.
 *
 * (c) Phalcon Team <team@phalcon.io>
 *
 * For the full copyright and license information, please view the LICENSE.txt
 * file that was distributed with this source code.
 */
/**
 * Phalcon\Logger\Adapter\Noop
 *
 * Adapter to store logs in plain text files
 *
 *```php
 * $logger = new \Phalcon\Logger\Adapter\Noop();
 *
 * $logger->log(\Phalcon\Logger::ERROR, "This is an error");
 * $logger->error("This is another error");
 *
 * $logger->close();
 *```
 */
ZEPHIR_INIT_CLASS(Phalcon_Logger_Adapter_Noop) {

	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Logger\\Adapter, Noop, phalcon, logger_adapter_noop, phalcon_logger_adapter_abstractadapter_ce, phalcon_logger_adapter_noop_method_entry, 0);

	return SUCCESS;

}

/**
 * Closes the stream
 */
PHP_METHOD(Phalcon_Logger_Adapter_Noop, close) {

	zval *this_ptr = getThis();


	RETURN_BOOL(1);

}

/**
 * Processes the message i.e. writes it to the file
 */
PHP_METHOD(Phalcon_Logger_Adapter_Noop, process) {

	zval *item, item_sub;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&item_sub);

	zephir_fetch_params_without_memory_grow(1, 0, &item);




}

